#include <windows.h>
#include <stdio.h>
#include <wchar.h>

#define _CRT_SECURE_NO_WARNINGS

// forward declarations
BOOL PrintStart(UINT32 file_no);
BOOL GetPrinterStatus(HANDLE hPrinter, DWORD *pStatus);
BOOL GetJobs(HANDLE hPrinter, DWORD dwcJobs);
BOOL IsPrinterStatusError(HANDLE hPrinter);
void IsPrintJobsState(HANDLE hPrinter, DWORD dwcJobs);
DWORD SendDataToPrinter(HANDLE hPrinter, UINT32 file_no);
UINT32 ReadPrintDataFile(PBYTE * printData, UINT32 file_no);

// unicode
#define CONSOLE_OUT wprintf
#define CONSOLE_IN wscanf
#define CONSOLE_IN_CHAR getwchar

#define STR_CMP wcscmp
#define STR_TO_INT _wtoi

#define STR_ELEM wchar_t
#define STR(x) L ## x

#define ESC_POS_B L"BSC10_ESCPOS_Bitimage.prn"
#define ESC_POS_T L"BSC10_ESCPOS_Text.prn"

wchar_t g_queueName[100 + 1] = {0};

int wmain(int argc, wchar_t *argv[ ], wchar_t *envp[ ])
{
    CONSOLE_OUT(STR("Enter the printer queue name: "));
    CONSOLE_IN(STR("%[^\t\n]"), g_queueName); CONSOLE_IN_CHAR();

    CONSOLE_OUT(STR("\n"));

    while(true)
    {
        CONSOLE_OUT(STR("[1] ESC/POS Bitmap print\n"));
        CONSOLE_OUT(STR("[2] ESC/POS Text   print\n"));
        CONSOLE_OUT(STR("[x] Quit\n"));

        STR_ELEM answerString[10];

        CONSOLE_OUT(STR("Select one of the above options: "));
        CONSOLE_IN(STR("%s"), answerString);
        CONSOLE_IN_CHAR();

        if(STR_CMP(answerString, STR("x")) == 0)
        {
            return 0;
        }

        int answer = STR_TO_INT(answerString);

        switch(answer)
        {
        case 1:
        case 2:
            PrintStart(answer);
            break;
        default:
            CONSOLE_OUT(STR("Invalid Option\n"));
            break;
        }

        CONSOLE_OUT(STR("\n"));
    }

    return 0;
}

BOOL PrintStart(UINT32 file_no)
{
    BOOL result;
	HANDLE hPrinter;
    DWORD dwJobId  = 0;
    DWORD dwNeeded = 0;
    PRINTER_INFO_2 *pi2 = NULL;

	result = OpenPrinter(g_queueName, &hPrinter, NULL);

    if(!result || (hPrinter== NULL))
    {
        CONSOLE_OUT(STR("Failure - OpenPrinter\n"));
        return FALSE;
    }

    if (IsPrinterStatusError(hPrinter))
    {
        ClosePrinter(hPrinter);
        return FALSE;
    }

    if ((dwJobId = SendDataToPrinter(hPrinter, file_no)) == 0)
    {
        CONSOLE_OUT(STR("Failure - WritePrinter.\n"));

        ClosePrinter(hPrinter);
        return FALSE;
    }

    IsPrintJobsState(hPrinter, dwJobId);

    ClosePrinter(hPrinter);

    CONSOLE_OUT(STR("Success\n"));

    return TRUE;
}

BOOL GetPrinterStatus(HANDLE hPrinter, DWORD *pStatus)
{
    DWORD          cByteNeeded;
    DWORD          cByteUsed;
    PRINTER_INFO_2 *pPrinterInfo2 = NULL;

    /* Get the buffer size needed. */
    if (!GetPrinter(hPrinter, 2, NULL, 0, &cByteNeeded))
    {
        if (GetLastError() != ERROR_INSUFFICIENT_BUFFER)
        {
            return FALSE;
        }
    }

    pPrinterInfo2 = (PRINTER_INFO_2 *)malloc(cByteNeeded);
    if (!(pPrinterInfo2))
    {
        /* Failure to allocate memory. */
        CONSOLE_OUT(STR("Failure to allocate memory.\n"));

        return FALSE;
    }

    ZeroMemory(pPrinterInfo2, cByteNeeded);

    /* Get the printer information. */ 
    if (!GetPrinter(hPrinter, 2, (LPBYTE)pPrinterInfo2, cByteNeeded, &cByteUsed))
    {
        /* Failure to access the printer. */
        CONSOLE_OUT(STR("Failure to access the printer.\n"));

        free(pPrinterInfo2);
        pPrinterInfo2 = NULL;
        return FALSE;
    }

    /*  Return the information. */
    *pStatus = pPrinterInfo2->Status;
    free(pPrinterInfo2);

    return TRUE;
}

BOOL GetJobs(HANDLE hPrinter, DWORD dwcJobs)
{
    DWORD      cByteNeeded;
    JOB_INFO_2 *pJobStorage = NULL;

    /* Get job storage space. */
    if (!GetJob(hPrinter, dwcJobs, 2, NULL, 0, (LPDWORD)&cByteNeeded))
    {
        if (GetLastError() != ERROR_INSUFFICIENT_BUFFER)
        {
            return FALSE;
        }
    }

    pJobStorage = (JOB_INFO_2 *)malloc(cByteNeeded);
    if (!pJobStorage)
    {
        /* Failure to allocate Job storage space. */
        CONSOLE_OUT(STR("Failure to allocate Job storage space.\n"));

        return FALSE;
    }

    ZeroMemory(pJobStorage, cByteNeeded);

    /* Get the list of jobs. */
    if (!GetJob(hPrinter, dwcJobs, 2, (LPBYTE)pJobStorage, cByteNeeded, (LPDWORD)&cByteNeeded))
    {
        /* Failure to access the print jobs. */
        CONSOLE_OUT(STR("Failure to access the print jobs.\n"));

        free(pJobStorage);
        pJobStorage   = NULL;
        return FALSE;
    }

    free(pJobStorage);

    return TRUE;
}

BOOL IsPrinterStatusError(HANDLE hPrinter)
{
    DWORD dwStatus;

    /*  Get the state information for the Printer Queue. */
    if (!GetPrinterStatus(hPrinter, &dwStatus))
    {
        return FALSE;
    }

    /*  If the Printer reports an error, believe it. */
    if (dwStatus & (PRINTER_STATUS_PAPER_OUT |
                    PRINTER_STATUS_OFFLINE   |
                    PRINTER_STATUS_DOOR_OPEN))
    {
        if (dwStatus & (PRINTER_STATUS_DOOR_OPEN))
        {
            CONSOLE_OUT(STR("The printer is offline - cover open.\n"));
        }

        if (dwStatus & (PRINTER_STATUS_PAPER_OUT))
        {
            CONSOLE_OUT(STR("The printer is offline - paper empty.\n"));
        }

        if (dwStatus & (PRINTER_STATUS_OFFLINE))
        {
            CONSOLE_OUT(STR("The printer is offline.\n"));
        }

        /*  The printer is an error. */
        return TRUE;
    }

    /*  No error condition. */
    return FALSE;
}

void IsPrintJobsState(HANDLE hPrinter, DWORD dwcJobs)
{
    BOOL  result;

    do
    {
        /*  Get the state information for the jobs in the Printer Queue. */
        result = GetJobs(hPrinter, dwcJobs);

        if (result)
        {
            IsPrinterStatusError(hPrinter);
        }
        Sleep(1000);

    }while(result);
}

DWORD SendDataToPrinter(HANDLE hPrinter, UINT32 file_no)
{
	DOC_INFO_1 docInfo1;
	DWORD      dwJobId;
	DWORD      dwBytesWritten;
    BYTE       *rawData;

    UINT32 ReadFileSize = ReadPrintDataFile(&rawData, file_no);

    if (ReadFileSize == 0)
    {
        CONSOLE_OUT(STR("Error - no print data.\n"));

        return 0;
    }

    docInfo1.pDocName    = TEXT("WritePrint RAW-Data");
    docInfo1.pOutputFile = NULL;
    docInfo1.pDatatype   = TEXT("RAW");

	// Inform the spooler the document is beginning.
    dwJobId = StartDocPrinter( hPrinter, 1, (LPBYTE)&docInfo1);

    if(dwJobId)
    {
        if(StartPagePrinter(hPrinter))
        {
            WritePrinter(hPrinter, rawData, ReadFileSize, &dwBytesWritten);

            EndPagePrinter(hPrinter);
        }

        EndDocPrinter(hPrinter);
    }

    free(rawData);

    return dwJobId;
}

UINT32 ReadPrintDataFile(PBYTE * printData, UINT32 file_no)
{
    HANDLE fileHandle;
    DWORD  fileSize;
    DWORD  readSize;
    PBYTE  pData         = NULL;
    UINT32 printDataSize = 0;

    /* Read print data from file */
    switch(file_no)
    {
    case 1:
        fileHandle = CreateFile(ESC_POS_B, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
        break;
    case 2:
        fileHandle = CreateFile(ESC_POS_T, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
        break;
    }
    
    if (fileHandle == INVALID_HANDLE_VALUE)
    {
        return 0;
    }

    fileSize = GetFileSize(fileHandle, &fileSize);
    if (fileSize == INVALID_FILE_SIZE)
    {
        CloseHandle(fileHandle);
        return 0;
    }

    printDataSize = fileSize;
    pData = (PBYTE)malloc(printDataSize);
    if (pData == NULL)
    {
        CloseHandle(fileHandle);
        return 0;
    }

    if (ReadFile(fileHandle, pData, printDataSize, &readSize, NULL) == FALSE)
    {
        free(pData);
        CloseHandle(fileHandle);
        return 0;
    }

    CloseHandle(fileHandle);

    *printData = pData;

    return printDataSize;
}
